#!/bin/sh

DRIVER=arcmsr

echo "arcmsr Driver post-Installation begining..."

MACHINE=`uname -m`
KERNEL=`uname -r`
export PATH=/bin:/sbin:/usr/bin:/usr/sbin

INITRD=initramfs

mkdir /tmp/modules
(cd /tmp/modules; gzip -dc /tmp/arcmsr/modules.cgz | cpio -idum) 1>/dev/null 2>&1 || { echo "Fail to extract drivers!"; exit 1; }

dver=`basename $(uname -r)`
for ver in /lib/modules/*; do
	kver=`basename $ver`
	mod=`(find /lib/modules/$kver/kernel/drivers/scsi -type f -name *.xz | head -1) 2>/dev/null`
	vermagic=`modinfo -F vermagic $mod 2> /dev/null`
#	[ "$vermagic" = "" ] && vermagic=`strings $mod | grep vermagic`
#	( echo "$vermagic" | grep " 586 " -s -q ) && MACHINE=i586
#	( echo "$vermagic" | grep " 686 " -s -q ) && MACHINE=i686
#	( echo "$vermagic" | grep " x86_64 " -s -q ) && MACHINE=x86_64
	MACHINE=`uname -m`

	if [ -d /lib/modules/${kver}/kernel ]; then
		echo "Updating ${kver}..."
		mv /boot/initramfs-${kver}.img /boot/initramfs-${kver}.img.old 
		mkdir -p /lib/modules/${kver}/extra/arcmsr/ &&
		cp -f /tmp/modules/${kver}/${MACHINE}/${DRIVER}.ko.xz /lib/modules/${kver}/extra/arcmsr/ &&
		/sbin/depmod -a ${kver}

		if [ $? = 1 ]; then
			echo "Kernel and driver version mismatch! Please check them."
			continue
		fi

		( grep -s -q scsi_mod /lib/modules/${kver}/modules.dep ) && PRESCSI="--preload scsi_mod"
		( grep -s -q sd_mod /lib/modules/${kver}/modules.dep ) && PRESD="--preload sd_mod"
		( grep -s -q scsi_wait_scan /lib/modules/${kver}/modules.dep ) && WITHWAIT="--with=scsi_wait_scan"

		/usr/bin/dracut -f /boot/${INITRD}-${kver}.img ${kver}

		if [ $? = 1 ]; then
			echo "Postinstall 2 failed! Please reinstall your GNU/Linux system."
			exit
		fi
	fi
done

cd /
rm -fr /tmp/modules
rm -fr /tmp/arcmsr

echo "arcmsr Driver Installation Step 2 Completed."
